#!/system/bin/sh

# ---------------------
# Convenience Functions
# ---------------------
#
. ./func.inc.sh

RM_BB_LN() {
  local bbdir=$1
  local bblndir=$2

  local bbexe=$bbdir/busybox

  local bbinode=X$($bbexe stat -L -c %i $bbdir/busybox 2> /dev/null)
  local bblist=
  local fileinode=

  bblist=$($bbdir/busybox --list 2> /dev/null)

  for filename in $bblist ; do
    fileinode=X$($bbexe stat -L -c %i $bblndir/$filename 2> /dev/null)

    if $bbexe [ "$fileinode" = "$bbinode" ] ; then
      RM_F $bblndir/$filename
    fi
  done
}


# ----------------
# Variable defines
# ----------------
#
PATH=/system/bin:/system/xbin:$PATH

BinLoc=/system/bin
XBinLoc=/system/xbin
AppLoc=/system/app
DataLoc=/data/data
DalvikLoc=/data/dalvik-cache

BBDirList="$XBinLoc $BinLoc"
BinFiles="busybox su"
OtherList="$AppLoc/Superuser.apk $DalvikLoc/system@app@Superuser.apk@classes.dex"
DirList="$DataLoc/com.noshufou.android.su"


# -------------
# Start Install
# -------------
#
echo -n "Uninstalling persistent root... "

mount -o remount,rw /system /system


for DirName in $BBDirList ; do
  RM_BB_LN $DirName $DirName
done


for FileName in $BinFiles ; do
  RM_F $XBinLoc/$FileName
  RM_F $BinLoc/$FileName
done


for FileName in $OtherList ; do
  RM_F $FileName
done


for DirName in $DirList ; do
  RM_RF $DirName
done


echo "Done"


# -------
# Sync FS
# -------
#
echo -n "Waiting for filesystem to sync... "
sync; sync; sync
sleep 6
mount -o remount,ro /system /system 2> /dev/null
echo "Done"
